/*
 * @(#)Task.java  1.0  2006-03-20
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.pert.model;

import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.*;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * A simulated Task.
 *
 * @author Werner Randelshofer
 * @version 1.0 2006-03-20 Created.
 */
public class Task extends AbstractElement implements DOMStorable {
  //  private String name;
    private int duration;
    private int startTime;
    
    /** Creates a new instance. */
    public Task() {
        final ResourceBundleUtil labels = PertModel.labels;
        name = labels.getString("taskDefaultName");
        startTime = 0;
    }
    /*
    public void setName(String newValue) {
        String oldValue = name;
        name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }
    public String getName() {
        return name;
    }*/
    public void setDuration(int newValue) {
        int oldValue = duration;
        duration = newValue;
        for (Task suc : getSuccessors()) {
            suc.updateStartTime();
        }
        firePropertyChange("duration", oldValue, newValue);
    }
    public int getDuration() {
        return duration;
    }
    public int getStartTime() {
        //System.out.println(getName()+".getStartTime():"+startTime);
        return startTime;
    }
    /*private*/ void updateStartTime() {
        int oldValue = startTime;
        startTime = 0;
        for (Task pre : getPredecessors()) {
            startTime = Math.max(startTime, pre.getStartTime() + pre.getDuration());
        }
        for (Task suc : getSuccessors()) {
            suc.updateStartTime();
        }
        //System.out.println(this+".updateStartTime "+startTime);
        firePropertyChange("startTime", oldValue, startTime);
    }
    
    /**
     * Returns dependent PertTasks which are directly connected via a
     * PertDependency to this Task.
     */
    public List<Task> getSuccessors() {
        LinkedList<Task> list = new LinkedList<Task>();
        for (SimulatedRelationship c : getRelationships(PertModel.DEPENDENCY)) {
            if (c.getStart() == this) {
                list.add((Task) c.getEnd());
            }
        }
        //System.out.println("successors of "+getName()+" "+list);
        return list;
    }
    
    /**
     * Returns predecessor PertTasks which are directly connected via a
     * PertDependency to this Task.
     */
    public List<Task> getPredecessors() {
        LinkedList<Task> list = new LinkedList<Task>();
        for (SimulatedRelationship c : getRelationships(PertModel.DEPENDENCY)) {
            if (c.getEnd() == this) {
                list.add((Task) c.getStart());
            }
        }
       // System.out.println("predecessors of "+getName()+" "+list);
        return list;
    }
    
    public int getSimulatedConcept() {
        return PertModel.TASK;
    }
    
    public Task clone() {
        Task that = (Task) super.clone();
        
        return that;
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name);
        out.addAttribute("duration", duration);
    }
    public void read(DOMInput in) {
        name = in.getAttribute("name", "Entity");
        duration = in.getAttribute("duration", 0);
    }
    public PertModel getERModel() {
        return (PertModel) getSimulation();
    }
    
    /**
     * Returns true, if the current task is a direct or
     * indirect dependent of the specified task.
     * If the dependency is cyclic, then this method returns true
     * if <code>this</code> is passed as a parameter and for every other
     * task in the cycle.
     */
    public boolean isDependentOf(Task t) {
        /*
        System.out.println(this+".pre="+getPredecessors());
        System.out.println(this+".suc="+getSuccessors());
        */
        if (this == t) return true;
        for (Task pre : getPredecessors()) {
            if (pre.isDependentOf(t)) {
                return true;
            }
        }
        return false;
    }
    
    public String toString() {
        return getName()+"#"+hashCode();
    }    
}
